#version 3.7;
global_settings { assumed_gamma 1.0 }

#declare Rnd1 = seed (11574); // init
#declare Rnd2 = seed (345653);// infections
#declare Rnd3 = seed (954175);// tests (random or false)
#declare Rnd4 = seed (102455);// displacement
#declare Rnd5 = seed (125);   // Q/H
#declare Rnd6 = seed (923125);// social distancing
#declare Rnd7 = seed (42932); // hospitalized/dead
#include "shapes.inc"
#include "shapes2.inc"
 
 
 

#declare Linf=14;      // length of infection (days)
#declare Pinf=.3;      // P of infection   // ****************************************************************to set 12a:.4    12bc:.3
#declare Ptest=.01;   // P of random tests (.01)
#declare Pfalse=.1;   // P of false negative tests (.1)
#declare Pdist=.4;      // P of connections   // ****************************************************************to set 12a:1     12bc:.4
#declare sizeX=32;     // population
#declare sizeZ=16;
#declare sizeC=9;      // max number of connections (array)
#declare heightGraph=10;
#declare stdLength=42;  // length of the runs (days)
#include "init.inc"
#include "figs.inc"


   
   
   
   
// graphs
Axes
#declare colG=<1,.5,.1>;
//                                0   1   1   1   1   1   1   1   1   1  10  11  12  13  14  15  16  17  18  19  20  21  22  23  24  25  26  27  28  29  30  31  32  33  34  35  36  37  38  39  40  41  42
#declare G1 = array[stdLength+1] {12, 48,120,202,291,364,424,460,483,500,505,505,505,505,500,464,392,310,221,148, 88, 52, 26,  9,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0}  //
#declare G2 = array[stdLength+1] {12, 20, 34, 49, 66, 91,112,149,171,194,219,244,271,292,317,334,348,352,348,336,315,295,275,261,243,218,193,173,145,122, 96, 77, 65, 53, 47, 33, 32, 23, 16, 12, 10,  9,  7}
/*
#for(NrG,0,stdLength,1)
object {
Point(NrG,G1[NrG]/(sizeX*sizeZ),<1,0,0>)
translate<0,0,.11>
}
#end

#for(NrG,0,stdLength,1)
object {
Point(NrG,G2[NrG]/(sizeX*sizeZ),<1,1,0>)
translate<0,0,.1>
}
#end
*/


Point(0,countEI/(sizeX*sizeZ),colG)
   
   
   
   



// develoap this day
#declare sumT=0;
#declare TmpStatuses=Statuses;

#for (NrD, 1, int(clock), 1)
    #declare TmpStatuses=Statuses;
// paste to here \/
    #for (NrX, 0, sizeX-1, 1)
        #for (NrZ, 0, sizeZ-1, 1)
            #if(isTS(Statuses[NrZ][NrX]))                                                    // just tested (-) S
                #declare TmpStatuses[NrZ][NrX]=valS;
                #declare Statuses[NrZ][NrX]=valS;
            #end
            #if(isTI(Statuses[NrZ][NrX]) & rand(Rnd3)<Ptest)                                 // just tested (-)!! I (fals negative)
                #declare TmpStatuses[NrZ][NrX]=TmpStatuses[NrZ][NrX]-valTI+valI;
                #declare Statuses[NrZ][NrX]=Statuses[NrZ][NrX]-valTI+valI;
            #end
            #if(isTI(Statuses[NrZ][NrX]))                                                   // just tested (+) Q
                #declare TmpStatuses[NrZ][NrX]=valQ;                                        // from zero! Q for Linf days
                #declare countEI=countEI-1;
            #end
//            #if((isS(Statuses[NrZ][NrX]) | isE(Statuses[NrZ][NrX]) | isI(Statuses[NrZ][NrX])) & rand(Rnd3)<Ptest)
            #if((isS(Statuses[NrZ][NrX]) | isE(Statuses[NrZ][NrX]) | isI(Statuses[NrZ][NrX])) & (int(clock)=5 |int(clock)=15 |int(clock)=25 |int(clock)=35))
                #declare sumT=sumT+1;
                #if(isS(Statuses[NrZ][NrX]))
                    #declare TmpStatuses[NrZ][NrX]=valTS;
                #elseif(isI(Statuses[NrZ][NrX]))
                    #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]-valI+valTI;
                #else  // isE
                    #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]-valE+valTI;
                #end

            #elseif(isE(Statuses[NrZ][NrX]) & isLast(Statuses[NrZ][NrX]))                    // last day E -> recovers
                #declare TmpStatuses[NrZ][NrX]=valR;
                #declare countEI=countEI-1;
            #elseif(isI(Statuses[NrZ][NrX]) & isLast(Statuses[NrZ][NrX]))                    // last day I -> recovers
                #declare TmpStatuses[NrZ][NrX]=valR;
                #declare countEI=countEI-1;
            #elseif(isQ(Statuses[NrZ][NrX]) & isLast(Statuses[NrZ][NrX]))                    // last day Q -> recovers
                #declare TmpStatuses[NrZ][NrX]=valR;
            #elseif(isH(Statuses[NrZ][NrX]) & isLast(Statuses[NrZ][NrX]))                    // last day H -> recovers
                #declare TmpStatuses[NrZ][NrX]=valR;

            #elseif(Statuses[NrZ][NrX]-valI=8)                                               // notiting symptoms -> quaratine
                #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]+1+valQ-valI;
                #declare countEI=countEI-1;
            #elseif(Statuses[NrZ][NrX]-valQ=10 & Severity[NrZ][NrX]>=SvalIH)                 // serious symptoms -> hospital
                #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]+1+valH-valQ;
            #elseif(Statuses[NrZ][NrX]-valH=12 & Severity[NrZ][NrX]=SvalIHd)                 // serious symptoms -> death in case of overloading ##### to develoap
                #declare TmpStatuses[NrZ][NrX]=valD;
            #elseif(Statuses[NrZ][NrX]-valH=12 & Severity[NrZ][NrX]=SvalIHD)                 // very serious symptoms -> death in all cases
                #declare TmpStatuses[NrZ][NrX]=valD;

            #elseif(isQ(Statuses[NrZ][NrX]))                                // no action, counter works
                #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]+1;                
            #elseif(isH(Statuses[NrZ][NrX]))                                // no action, counter works
                #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]+1;                

            #elseif(isE(Statuses[NrZ][NrX]) | isI(Statuses[NrZ][NrX]))      // counter works + optional infections
                #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]+1;
                #for (NrC, 0, sizeC-1, 1)
                    //  allowed direction            susceptible                                                                        probability
                    #if(Connections[NrZ][NrX][NrC] & isS(TmpStatuses[mod((NrZ+CZ[NrC]+sizeZ),sizeZ)][mod((NrX+CX[NrC]+sizeX),sizeX)]) & rand(Rnd2)<Pinf)
                        #declare countEI=countEI+1;
                        #if(Severity[mod((NrZ+CZ[NrC]+sizeZ),sizeZ)][mod((NrX+CX[NrC]+sizeX),sizeX)]=SvalE)
                            #declare TmpStatuses[mod((NrZ+CZ[NrC]+sizeZ),sizeZ)][mod((NrX+CX[NrC]+sizeX),sizeX)]=valE;
                        #else
                            #declare TmpStatuses[mod((NrZ+CZ[NrC]+sizeZ),sizeZ)][mod((NrX+CX[NrC]+sizeX),sizeX)]=valI;
                        #end
                        /*object {   // !!!only for animation
                            Infection(NrC,clock-int(clock))
                            translate<NrX,0,NrZ>
                        }*/
                    #end
                #end
            #end
        #end
    #end
// paste to here /\

    #if(countEI>maxEI)
        #declare maxEI=countEI;
    #end
    Point(NrD,countEI/(sizeX*sizeZ),colG)    
    #declare Statuses=TmpStatuses;
#end


// animation for current day - copied from above (no need of deleting counters)



// copy from here \/
    #for (NrX, 0, sizeX-1, 1)
        #for (NrZ, 0, sizeZ-1, 1)
            #if(isTS(Statuses[NrZ][NrX]))                                                    // just tested (-) S
                #declare TmpStatuses[NrZ][NrX]=valS;
                #declare Statuses[NrZ][NrX]=valS;
            #end
            #if(isTI(Statuses[NrZ][NrX]) & rand(Rnd3)<Ptest)                                 // just tested (-)!! I (fals negative)
                #declare TmpStatuses[NrZ][NrX]=TmpStatuses[NrZ][NrX]-valTI+valI;
                #declare Statuses[NrZ][NrX]=Statuses[NrZ][NrX]-valTI+valI;
            #end
            #if(isTI(Statuses[NrZ][NrX]))                                                   // just tested (+) Q
                #declare TmpStatuses[NrZ][NrX]=valQ;                                        // from zero! Q for Linf days
                //!!! #declare countEI=countEI-1;
            #end
//            #if((isS(Statuses[NrZ][NrX]) | isE(Statuses[NrZ][NrX]) | isI(Statuses[NrZ][NrX])) & rand(Rnd3)<Ptest)
            #if((isS(Statuses[NrZ][NrX]) | isE(Statuses[NrZ][NrX]) | isI(Statuses[NrZ][NrX])) & (int(clock)=5 |int(clock)=15 |int(clock)=25 |int(clock)=35))
                #declare sumT=sumT+1;
                #if(isS(Statuses[NrZ][NrX]))
                    #declare TmpStatuses[NrZ][NrX]=valTS;
                #elseif(isI(Statuses[NrZ][NrX]))
                    #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]-valI+valTI;
                #else  // isE
                    #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]-valE+valTI;
                #end

            #elseif(isE(Statuses[NrZ][NrX]) & isLast(Statuses[NrZ][NrX]))                    // last day E -> recovers
                #declare TmpStatuses[NrZ][NrX]=valR;
                //!!! #declare countEI=countEI-1;
            #elseif(isI(Statuses[NrZ][NrX]) & isLast(Statuses[NrZ][NrX]))                    // last day I -> recovers
                #declare TmpStatuses[NrZ][NrX]=valR;
                //!!! #declare countEI=countEI-1;
            #elseif(isQ(Statuses[NrZ][NrX]) & isLast(Statuses[NrZ][NrX]))                    // last day Q -> recovers
                #declare TmpStatuses[NrZ][NrX]=valR;
            #elseif(isH(Statuses[NrZ][NrX]) & isLast(Statuses[NrZ][NrX]))                    // last day H -> recovers
                #declare TmpStatuses[NrZ][NrX]=valR;

            #elseif(Statuses[NrZ][NrX]-valI=8)                                               // notiting symptoms -> quaratine
                #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]+1+valQ-valI;
                //!!! #declare countEI=countEI-1;
            #elseif(Statuses[NrZ][NrX]-valQ=10 & Severity[NrZ][NrX]>=SvalIH)                 // serious symptoms -> hospital
                #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]+1+valH-valQ;
            #elseif(Statuses[NrZ][NrX]-valH=12 & Severity[NrZ][NrX]=SvalIHd)                 // serious symptoms -> death in case of overloading ##### to develoap
                #declare TmpStatuses[NrZ][NrX]=valD;
            #elseif(Statuses[NrZ][NrX]-valH=12 & Severity[NrZ][NrX]=SvalIHD)                 // very serious symptoms -> death in all cases
                #declare TmpStatuses[NrZ][NrX]=valD;

            #elseif(isQ(Statuses[NrZ][NrX]))                                // no action, counter works
                #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]+1;                
            #elseif(isH(Statuses[NrZ][NrX]))                                // no action, counter works
                #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]+1;                

            #elseif(isE(Statuses[NrZ][NrX]) | isI(Statuses[NrZ][NrX]))      // counter works + optional infections
                #declare TmpStatuses[NrZ][NrX]=Statuses[NrZ][NrX]+1;
                #for (NrC, 0, sizeC-1, 1)
                    //  allowed direction            susceptible                                                                        probability
                    #if(Connections[NrZ][NrX][NrC] & isS(TmpStatuses[mod((NrZ+CZ[NrC]+sizeZ),sizeZ)][mod((NrX+CX[NrC]+sizeX),sizeX)]) & rand(Rnd2)<Pinf)
                        //!!! #declare countEI=countEI+1;
                        #if(Severity[mod((NrZ+CZ[NrC]+sizeZ),sizeZ)][mod((NrX+CX[NrC]+sizeX),sizeX)]=SvalE)
                            #declare TmpStatuses[mod((NrZ+CZ[NrC]+sizeZ),sizeZ)][mod((NrX+CX[NrC]+sizeX),sizeX)]=valE;
                        #else
                            #declare TmpStatuses[mod((NrZ+CZ[NrC]+sizeZ),sizeZ)][mod((NrX+CX[NrC]+sizeX),sizeX)]=valI;
                        #end
                        object {   // !!!only for animation
                            Infection(NrC,clock-int(clock))
                            translate<NrX,0,NrZ>
                        }
                    #end
                #end
            #end
        #end
    #end
// copy from here /\






// current statistics
#declare countP=0;
#declare countS=0;
#declare countE=0;
#declare countI=0;
#declare countQ=0;
#declare countH=0;
#declare countD=0;
#declare countR=0;

#for (NrX, 0, sizeX-1, 1)
    #for (NrZ, 0, sizeZ-1, 1)
        #if(isP(Statuses[NrZ][NrX]))
            #declare countP=countP+1;
        #elseif(isS(Statuses[NrZ][NrX]) | isTS(Statuses[NrZ][NrX]))
            #declare countS=countS+1;
        #elseif(isE(Statuses[NrZ][NrX]))
            #declare countE=countE+1;
        #elseif(isI(Statuses[NrZ][NrX]))
            #declare countI=countI+1;
        #elseif(isQ(Statuses[NrZ][NrX]))
            #declare countQ=countQ+1;
        #elseif(isH(Statuses[NrZ][NrX]))
            #declare countH=countH+1;
        #elseif(isD(Statuses[NrZ][NrX]))
            #declare countD=countD+1;
        #elseif(isR(Statuses[NrZ][NrX]))
            #declare countR=countR+1;
        #end    
    #end
#end


/*
camera {       //front top
//    location  <(sizeX-1)/2+final_clock/2*sin(clock/final_clock*2*pi*3), 35, -40>
    location  <(sizeX-1)/2, 40, -42>
    look_at   <(sizeX-1)/2, 0,  sizeZ/2>
    angle 32
    right x*image_width/image_height
}
*/

/*
camera {       //front top - grafikonhoz
//    location  <(sizeX-1)/2+final_clock/2*sin(clock/final_clock*2*pi*3), 35, -40>
    location  <(sizeX-1)/2, 20, -52>
    look_at   <(sizeX-1)/2, 3,  sizeZ/2>
    angle 30
    right x*image_width/image_height
}
*/

camera {       //front top - grafikonhoz jobb
    location  <(sizeX-1)/2, 20, -42>
    look_at   <(sizeX-1)/2, 4,  sizeZ/2>
    angle 39
    right x*image_width/image_height
}




/*
camera {       //front close
    location  <(sizeX-1)/2, 4, -10>
    look_at   <(sizeX-1)/2, 3,  0>
    angle 30
    right x*image_width/image_height
}
*/

/*
camera {        // top
    location  <(sizeX-1)/2, 40, (sizeZ-1)/2-3>
    look_at   <(sizeX-1)/2, 0,  (sizeZ-1)/2-1>
    angle 50
    right x*image_width/image_height
}
*/


light_source {
    0*x
    color rgb <1,1,1>*.5
    translate <-20, 40, -40>
}
light_source {
    0*x
    color rgb <1,1,1>*.6
    translate <-50, 20, -10>
    shadowless
}
light_source {
    0*x
    color rgb <1,1,1>*.6
    translate <20, 40, -30>
    shadowless
}
light_source {
    0*x
    color rgb <1,1,1>*.9
    translate <-2, 0, -30>
    shadowless
}

sky_sphere {
    pigment { color rgb<.9,.9,1>
    }
}

plane { <0,1,0>, 0  hollow // normal vector, distance to zero ----
    texture{ 
        pigment{ color rgb<0.35,0.6, 0> }
	    // normal { bumps 0.25 scale 0.05 }
        finish { phong 1 }
    }
}








// draw population
union {
    #for (NrX, 0, sizeX-1, 1) // outer loop
        #for (NrZ, 0, sizeZ-1, 1) // inner loop
            object {
                AniPerson(Statuses[NrZ][NrX],TmpStatuses[NrZ][NrX],clock-int(clock))
                translate<NrX*1,0,NrZ*1>
            }
        #end
    #end
    rotate<0,0,0> 
    translate<0,0,0>
}




Display(clock,countP,countS,countE,countI,countQ,countH,countD,countR)
Stats(maxEI,countEI,sumT)
Watch(clock)
DashBoard(clock,countEI,maxEI,
    concat("  P:",str(countP,3,0),"  S:",str(countS,3,0),"  Q:",str(countQ,3,0),"  R:",str(countR,3,0)),
    concat("  E:",str(countE,3,0),"  I:",str(countI,3,0)),
    concat("  H:",str(countH,3,0),"  D:",str(countD,3,0)))

//Family(colS,colS,colI,colR)


