//**********************************************************Severity
// 0                - S->E
// 1                - S->I
// 2                - S->I->H
// 3                - S->I->H->D if H is overloaded  ##### to develoap
// 4                - S->I->H->D

#declare SvalE   = 0;
#declare SvalI   = 1;
#declare SvalIH  = 2;
#declare SvalIHd = 3;
#declare SvalIHD = 4;


//**********************************************************Statuses
// -1               - P rotected
// 0                - S usceptible
// 1                - Tested Susceptible
// 100..100+Linf    - Tested exposed or Infected
// 200..200+Linf    - E xposed (no symptoms)
// 300..300+Linf    - I nfected
// 400..400+Linf    - Q uarantined
// 500..500+Linf    - H ospitalized
// 666              - D ead
// 777              - R ecovered
// 999              - X error


#declare valP = -1;
#declare valS = 0;
#declare valTS= 1;
#declare valTI= 100;
#declare valE = 200;
#declare valI = 300;
#declare valQ = 400;
#declare valH = 500;
#declare valD = 666;
#declare valR = 777;
#declare valX = 999;

#declare isP = function(sss) { (sss=valP) }
#declare isS = function(sss) { (sss=valS) }
#declare isTS = function(sss) { (sss=valTS) }
#declare isTI = function(sss) { (sss>=valTI & sss<valTI+100) }
#declare isE = function(sss) { (sss>=valE & sss<valE+100) }
#declare isI = function(sss) { (sss>=valI & sss<valI+100) }
#declare isQ = function(sss) { (sss>=valQ & sss<valQ+100) }
#declare isH = function(sss) { (sss>=valH & sss<valH+100) }
#declare isD = function(sss) { (sss=valD) }
#declare isR = function(sss) { (sss=valR) }
#declare isX = function(sss) { (sss=valX) }

#declare isLast = function(sss) { (sss=valE+Linf-1 | sss=valI+Linf-1 | sss=valQ+Linf-1 | sss=valH+Linf-1) } // about to recover

#declare colP=<.4,.4,.8>; 
#declare colS=<.2,.2,.8>; 
#declare colE=<.8,.5,.4>; 
#declare colI=<.8,.2,.2>; 
#declare colQ=<.8,.4,.4>; 
#declare colH=<.8,.4,.4>; 
#declare colD=<.1,.1,.1>; 
#declare colR=<.2,.8,.2>; 
#declare colX=<0,1,1>; 



// initial status
#declare maxEI=0;
#declare countEI=0;
#declare Statuses = array[sizeZ][sizeX];
#declare Severity = array[sizeZ][sizeX];
#declare Connections = array[sizeZ][sizeX][sizeC];
#declare CX = array[sizeC];
#declare CZ = array[sizeC];


#for (NrX, 0, sizeX-1, 1)
    #for (NrZ, 0, sizeZ-1, 1)
        #declare r=rand(Rnd7);
        #if(r<=.01)
            #declare Severity[NrZ][NrX]=SvalE;    // S->E
        #elseif(r<=.02)
            #declare Severity[NrZ][NrX]=SvalIH;   // S->I->H
        #elseif(r<=.03)
            #declare Severity[NrZ][NrX]=SvalIHd;  // S->I->H->D if H is overloaded  ##### to develoap
        #elseif(r<=.04)
            #declare Severity[NrZ][NrX]=SvalIHD;  // S->->IH->D
        #else
            #declare Severity[NrZ][NrX]=SvalI;    // S->I
        #end    
    #end
#end

// ##!## latvanyossagnak...
#declare Severity[0][16]=SvalE;
#declare Severity[0][17]=SvalI;
#declare Severity[0][18]=SvalIH;
/*
#declare Severity[0][19]=SvalIHd;
#declare Severity[0][20]=SvalIHD;
#declare Severity[0][21]=SvalE;
#declare Severity[0][22]=SvalI;
#declare Severity[0][23]=SvalIH;
#declare Severity[0][24]=SvalIHd;
*/
#declare Severity[0][25]=SvalIHD;


// initial infexted
// all severity will be 'normal'
#for (NrX, 0, sizeX-1, 1)
    #for (NrZ, 0, sizeZ-1, 1)
        #declare r=rand(Rnd1);
        #if(r<=.01)
            #declare Statuses[NrZ][NrX]=valI;
            #declare maxEI=maxEI+1;
            #declare countEI=countEI+1;
            #declare Severity[NrZ][NrX]=SvalI;
        #elseif(r<=.02)
            #declare Statuses[NrZ][NrX]=valI+3;
            #declare maxEI=maxEI+1;
            #declare countEI=countEI+1;
            #declare Severity[NrZ][NrX]=SvalI;
        #elseif(r<=.03)
            #declare Statuses[NrZ][NrX]=valI+6;
            #declare maxEI=maxEI+1;
            #declare countEI=countEI+1;
            #declare Severity[NrZ][NrX]=SvalI;
        #else
            #declare Statuses[NrZ][NrX]=valS;
        #end    
    #end
#end




// connection types
#for (NrC, 0, sizeC-1, 1)
    #declare CX[NrC]=0;
    #declare CZ[NrC]=0;
#end
#declare CX[1]=1;  // E
#declare CZ[1]=0;
#declare CX[2]=0;  // S
#declare CZ[2]=-1;
#declare CX[3]=-1; // W
#declare CZ[3]=0;
#declare CX[4]=0;  // N
#declare CZ[4]=1;

#declare CX[5]=1;  // SE
#declare CZ[5]=-1;
#declare CX[6]=-1; // SW
#declare CZ[6]=-1;
#declare CX[7]=-1; // NW
#declare CZ[7]=1;
#declare CX[8]=1;  // NE
#declare CZ[8]=1;

// valid connections for people
#for (NrX, 0, sizeX-1, 1)
    #for (NrZ, 0, sizeZ-1, 1)
        #for (NrC, 0, sizeC-1, 1)
            #declare Connections[NrZ][NrX][NrC]=false;
        #end
        #if(rand(Rnd6)<=Pdist)
            #declare Connections[NrZ][NrX][1]=true;
        #end
        #if(rand(Rnd6)<=Pdist)
            #declare Connections[NrZ][NrX][2]=true;
        #end
        #if(rand(Rnd6)<=Pdist)
            #declare Connections[NrZ][NrX][3]=true;
        #end
        #if(rand(Rnd6)<=Pdist)
            #declare Connections[NrZ][NrX][4]=true;
        #end
        #if(rand(Rnd6)<=Pdist)
            #declare Connections[NrZ][NrX][5]=true;
        #end
        #if(rand(Rnd6)<=Pdist)
            #declare Connections[NrZ][NrX][6]=true;
        #end
        #if(rand(Rnd6)<=Pdist)
            #declare Connections[NrZ][NrX][7]=true;
        #end
        #if(rand(Rnd6)<=Pdist)
            #declare Connections[NrZ][NrX][8]=true;
        #end
    #end
#end
// no periodic boundary condition
#for (NrX, 0, sizeX-1, 1)
    #declare Connections[sizeZ-1][NrX][4]=false;
    #declare Connections[sizeZ-1][NrX][7]=false;
    #declare Connections[sizeZ-1][NrX][8]=false;

    #declare Connections[0][NrX][2]=false;
    #declare Connections[0][NrX][5]=false;
    #declare Connections[0][NrX][6]=false;
#end
#for (NrZ, 0, sizeZ-1, 1)
    #declare Connections[NrZ][sizeX-1][1]=false;
    #declare Connections[NrZ][sizeX-1][8]=false;
    #declare Connections[NrZ][sizeX-1][5]=false;

    #declare Connections[NrZ][0][3]=false;
    #declare Connections[NrZ][0][6]=false;
    #declare Connections[NrZ][0][7]=false;
#end

