





#macro Display(day,p,s,e,i,q,h,d,r) 
text { ttf "arial.ttf", concat("Day: ", str(int(day),2,0),"  P:",str(p,3,0),"  S:",str(s,3,0),"  E:",str(e,3,0),"  I:",str(i,3,0),"  Q:",str(q,3,0),"  H:",str(h,3,0),"  D:",str(d,3,0),"  R:",str(r,3,0)), 0.02, 0.0 // thickness, offset
    texture{ 
        pigment{ color rgb<1,1,1>*1.3 } 
        finish { phong 0.1 }
    }
    scale<.8,1,.8>
    rotate<90,0,0>
    translate<(sizeX-1)/2-10,0.1,-1.5>
    no_shadow
}
#end

#macro Stats(maxActive,active,uT) // maxI, tests
text { ttf "arial.ttf", concat("MaxA: ", str(maxActive,3,0),"   Active: ", str(active,3,0),"  Used tests:",str(uT,3,0)), 0.02, 0.0 // thickness, offset
    texture{ 
        pigment{ color rgb<1,1,1>*1.3 } 
        finish { phong 0.1 }
    }
    scale<.8,1,.8>
    rotate<90,0,0>
    translate<(sizeX-1)/2-5,0.1,-3>
    no_shadow
}
#end

#macro Watch(a) 
text { ttf "arial.ttf", concat("time: ", str(int((a-int(a))*24),2,0),":", str(int((a*24-int(a*24))*60),-2,0)), 0.02, 0.0 // thickness, offset
    texture{ 
        pigment{ color rgb<1,1,1>*1.3 } 
        finish { phong 0.1 }
    }
    scale<.8,1,.8>
    rotate<90,0,0>
    translate<(sizeX-1)/2-3,0.1,-4.5>
    no_shadow
}
#end




#declare Strength1 = 1.0; //(+ or -) strength of component's radiating density
#declare Radius1  = 1.00; //(0 < Radius) outer sphere of influence on other components

#macro AniPerson(s,tmp,p)
    #if(isP(s) & isP(tmp))
        union {
            blob{
                threshold 0.65 
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colP}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            box{
                <-.45,0,-.45>,<.45,2.5,.45>
                pigment{ color rgbt<1,1,1,.5>}
            }
        }
    #elseif(isP(s) & isS(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colP*(1-p)+colS*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,(1-p)*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isS(s) & isS(tmp))
        blob{
            threshold 0.65 
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colS}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isS(s) & isTS(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colS*(1-p)+colS*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            torus { 0.5,0.05
                texture { 
                    pigment{ color rgb<1,1,1>}
                    finish { phong 1 reflection 0.00}
                }
                translate<0,0.05+2*p,0>
            }
            torus { 0.5,0.05
                texture { 
                    pigment{ color rgb<1,1,1>}
                    finish { phong 1 reflection 0.00}
                }
                translate<0,0.05+2*p+.3,0>
            }
            torus { 0.5,0.05
                texture { 
                    pigment{ color rgb <1,1,1>*(1-p)+<0,1,0>*p}
                    finish { phong 1 reflection 0.00}
                }
                translate<0,0.05+2*p+.6,0>
            }
        }
    #elseif(isE(s) & isTI(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colE*(1-p)+colI*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            torus { 0.5,0.05
                texture { 
                    pigment{ color rgb<1,1,1>}
                    finish { phong 1 reflection 0.00}
                }
                translate<0,0.05+2*p,0>
            }
            torus { 0.5,0.05
                texture { 
                    pigment{ color rgb<1,1,1>}
                    finish { phong 1 reflection 0.00}
                }
                translate<0,0.05+2*p+.3,0>
            }
            torus { 0.5,0.05
                texture { 
                    pigment{ color <1,1,1>*(1-p)+<1,0,0>*p}
                    finish { phong 1 reflection 0.00}
                }
                translate<0,0.05+2*p+.6,0>
            }
        }
    #elseif(isI(s) & isTI(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colI*(1-p)+colI*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            torus { 0.5,0.05
                texture { 
                    pigment{ color rgb<1,1,1>}
                    finish { phong 1 reflection 0.00}
                }
                translate<0,0.05+2*p,0>
            }
            torus { 0.5,0.05
                texture { 
                    pigment{ color rgb<1,1,1>}
                    finish { phong 1 reflection 0.00}
                }
                translate<0,0.05+2*p+.3,0>
            }
            torus { 0.5,0.05
                texture { 
                    pigment{ color rgb <1,1,1>*(1-p)+<1,0,0>*p}
                    finish { phong 1 reflection 0.00}
                }
                translate<0,0.05+2*p+.6,0>
            }
        }
    #elseif(isS(s) & isE(tmp))
        blob{
            threshold 0.65 
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colS*(1-p)+colE*p}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isS(s) & isI(tmp))
        blob{
            threshold 0.65 
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colS*(1-p)+colI*p}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isE(s) & isI(tmp))
        blob{
            threshold 0.65 
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colE*(1-p)+colI*p}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isE(s) & isE(tmp))
        blob{
            threshold 0.65
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colE}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isI(s) & isI(tmp))
        blob{
            threshold 0.65
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colI}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isS(s) & isQ(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colS*(1-p)+colQ*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,p*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isE(s) & isQ(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colE*(1-p)+colQ*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,p*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isI(s) & isQ(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colI*(1-p)+colQ*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,p*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isTI(s) & isQ(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colI*(1-p)+colQ*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,p*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isTI(s) & isH(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colI*(1-p)+colH*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,p*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isQ(s) & isQ(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colQ}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            box{
                <-.45,0,-.45>,<.45,2.5,.45>
                pigment{ color rgbt<1,1,1,.5>}
            }
        }
    #elseif(isQ(s) & isR(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colQ*(1-p)+colR*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,(1-p)*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isE(s) & isH(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colE*(1-p)+colH*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,p*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isI(s) & isH(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colI*(1-p)+colH*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,p*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isH(s) & isH(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colH}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            box{
                <-.45,0,-.45>,<.45,2.5,.45>
                pigment{ color rgbt<1,1,1,.5>}
            }
            box{
                <-.3,2.5,-.1>,<.3,2.51,.1>
                pigment{ color rgb<1,0,0>}
            }
            box{
                <-.1,2.5,-.3>,<.1,2.51,.3>
                pigment{ color rgb<1,0,0>}
            }
        }
    #elseif(isH(s) & isQ(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colH}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            box{
                <-.45,0,-.45>,<.45,2.5,.45>
                pigment{ color rgbt<1,1,1,.5>}
            }
            #if(p<0.25 | (p> .5 & p<.75))
                box{
                    <-.3,2.5,-.1>,<.3,2.51,.1>
                    pigment{ color rgb<1,0,0>}
                }
                box{
                    <-.1,2.5,-.3>,<.1,2.51,.3>
                    pigment{ color rgb<1,0,0>}
                }
            #end
        }
    #elseif(isQ(s) & isH(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colH}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            box{
                <-.45,0,-.45>,<.45,2.5,.45>
                pigment{ color rgbt<1,1,1,.5>}
            }
            #if(p<0.25 | (p> .5 & p<.75))
                box{
                    <-.3,2.5,-.1>,<.3,2.51,.1>
                    pigment{ color rgb<0,0,1>}
                }
                box{
                    <-.1,2.5,-.3>,<.1,2.51,.3>
                    pigment{ color rgb<1,0,0>}
                }
            #else
                box{
                    <-.3,2.5,-.1>,<.3,2.51,.1>
                    pigment{ color rgb<1,0,0>}
                }
                box{
                    <-.1,2.5,-.3>,<.1,2.51,.3>
                    pigment{ color rgb<0,0,1>}
                }
            #end
        }
    #elseif(isH(s) & isR(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colH*(1-p)+colR*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,(1-p)*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isH(s) & isD(tmp))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colH*(1-p)+colD*p}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            #difference {
                box{
                    <-.45,0,-.45>,<.45,2.5,.45>
                    pigment{ color rgbt<1,1,1,.5>}
                }
                box{
                    <-.5,(1-p)*2.5,-.5>,<.5,2.5,.5>
                    pigment{ color rgbt<1,1,1,1>}
                }
            }
        }
    #elseif(isD(s) & isD(tmp))
        union {           
            blob{
                threshold 0.65 
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colD}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(0*rand(Rnd4)-.5)*5>   // no effect, but using rnad
                translate<(0*rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            sphere_sweep {
                linear_spline
                2,
                <-0.1, 2.5, 0>, 0.05
                < 0.1, 2.5, 0>, 0.05
            
                texture{ 
                    pigment{ color rgb colD}
                    finish { phong 1 }
                }
            }
            sphere_sweep {
                linear_spline
                2,
                < 0.0, 2.6, 0>, 0.05
                < 0.0, 2.4, 0>, 0.05
            
                texture{ 
                    pigment{ color rgb colD}
                    finish { phong 1 }
                }
            }
        }
    #elseif(isE(s) & isR(tmp))
        blob{
            threshold 0.65
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colE*(1-p)+colR*p }
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isI(s) & isR(tmp))
        blob{
            threshold 0.65
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colI*(1-p)+colR*p }
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isR(s) & isR(tmp))
        blob{
            threshold 0.65
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colR}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #else
        blob{
            threshold 0.65
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colX}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #end    

#end


#macro Person(s)
    #if(isP(s))
        union {
            blob{
                threshold 0.65 
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colP}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            box{
                <-.45,0,-.45>,<.45,2.5,.45>
                pigment{ color rgbt<1,1,1,.5>}
            }
        }
    #elseif(isS(s))
        blob{
            threshold 0.65 
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colS}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isE(s))
        blob{
            threshold 0.65
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colE}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isI(s))
        blob{
            threshold 0.65
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colI}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #elseif(isQ(s))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colQ}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            box{
                <-.45,0,-.45>,<.45,2.5,.45>
                pigment{ color rgbt<1,1,1,.5>}
            }
        }
    #elseif(isH(s))
        union {
            blob{
                threshold 0.65
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colH}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                rotate<0,0,(rand(Rnd4)-.5)*2>
                translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            box{
                <-.45,0,-.45>,<.45,2.5,.45>
                pigment{ color rgbt<1,1,1,.5>}
            }
            box{
                <-.3,2.5,-.1>,<.3,2.51,.1>
                pigment{ color rgb<1,0,0>}
            }
            box{
                <-.1,2.5,-.3>,<.1,2.51,.3>
                pigment{ color rgb<1,0,0>}
            }
        }
    #elseif(isD(s))
        union {
            blob{
                threshold 0.65 
                cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
                sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
                cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
                cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
                texture{ 
                    pigment{ color rgb colD}
                    finish { phong 1 }
                }
                scale<.5,.5,.5>
                //rotate<0,0,(rand(Rnd4)-.5)*5>
                //translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
            }
            sphere_sweep {
                linear_spline
                2,
                <-0.1, 2.5, 0>, 0.05
                < 0.1, 2.5, 0>, 0.05
            
                texture{ 
                    pigment{ color rgb colD}
                    finish { phong 1 }
                }
            }
            sphere_sweep {
                linear_spline
                2,
                < 0.0, 2.6, 0>, 0.05
                < 0.0, 2.4, 0>, 0.05
            
                texture{ 
                    pigment{ color rgb colD}
                    finish { phong 1 }
                }
            }
        }
    #elseif(isR(s))
        blob{
            threshold 0.65
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colR}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #else
        blob{
            threshold 0.65
            cylinder{<0, 0, 0>,< 0, 3, 0>, Radius1, Strength1}
            sphere{  < 0, 4.25, 0>, Radius1, Strength1*1.5}
            cylinder{<.5, 2, 0>,<.5, 3, 0>, Radius1/3, Strength1}
            cylinder{<-.5, 2, 0>,<-.5, 3, 0>, Radius1/3, Strength1}
            texture{ 
                pigment{ color rgb colX}
                finish { phong 1 }
            }
            scale<.5,.5,.5>
            rotate<0,0,(rand(Rnd4)-.5)*2>
            translate<(rand(Rnd4)-.5)*.2,0,(rand(Rnd4)-.5)*.2>
        }
    #end    

#end



#macro Family(a,b,c,d) 
union {
    object {
        Person
        pigment { color rgb a }
        finish { phong 1 }
        translate<0,0,0>
        //translate<rand(Rnd2)/3,0,NrZ*1>
    }
    object {
        Person
        pigment { color rgb b }
        finish { phong 1 }
        translate<1,0,0>
        //translate<rand(Rnd2)/3,0,NrZ*1>
    }
    object {
        Person
        pigment { color rgb c }
        finish { phong 1 }
        translate<2,0,0>
        //translate<rand(Rnd2)/3,0,NrZ*1>
    }
    object {
        Person
        pigment { color rgb d }
        finish { phong 1 }
        translate<3,0,0>
        //translate<rand(Rnd2)/3,0,NrZ*1>
    }
}
#end


#macro Infection(d,p) // destination, progress
    #if(d>=1 & d<=4)
    union { 
        #if(p<.5)
            #for (I, 0, 180*p*2, 5) 
                sphere { <0,0,0>, 0.05 
                    texture { 
                        pigment{ color rgb<1.00, 0.70, 0.00>}
                        finish { phong 1.0 reflection 0.00}
                    }
                    translate<-.5,0,0>
                    rotate<0,0,-I>
                    translate<.5,0,0>
                }
            
            #end
        #else
            #for (I, (2*p-1)*180, 180, 5) 
                sphere { <0,0,0>, 0.05 
                    texture { 
                        pigment{ color rgb<1.00, 0.70, 0.00>}
                        finish { phong 1.0 reflection 0.00}
                    }
                    translate<-.5,0,0>
                    rotate<0,0,-I>
                    translate<.5,0,0>
                }
            
            #end
        #end
        
        #if(d=1)
            rotate<0,0,0>
        #elseif(d=2)
            rotate<0,90,0>
        #elseif(d=3)
            rotate<0,180,0>
        #elseif(d=4)
            rotate<0,270,0>
        #end
        
        scale 1 
        translate<0,2.7,0>
    }
    #elseif(d>=5 & d<=8)
    union { 
        #if(p<.5)
            #for (I, 0, 180*p*2, 5) 
                sphere { <0,0,0>, 0.05 
                    texture { 
                        pigment{ color rgb<1.00, 0.70, 0.00>}
                        finish { phong 1.0 reflection 0.00}
                    }
                    translate<-.5,0,0>
                    rotate<0,0,-I>
                    translate<.5,0,0>
                }
            
            #end
        #else
            #for (I, (2*p-1)*180, 180, 5) 
                sphere { <0,0,0>, 0.05 
                    texture { 
                        pigment{ color rgb<1.00, 0.70, 0.00>}
                        finish { phong 1.0 reflection 0.00}
                    }
                    translate<-.5,0,0>
                    rotate<0,0,-I>
                    translate<.5,0,0>
                }
            
            #end
        #end
    
        scale<1.4,1,1>
        
        #if(d=5)
            rotate<0,45,0>
        #elseif(d=6)
            rotate<0,45+90,0>
        #elseif(d=7)
            rotate<0,45+180,0>
        #elseif(d=8)
            rotate<0,45+270,0>
        #end
        
        translate<0,2.7,0>
    }
    #end
#end 

#declare DegAxes = atan2d(15,42+sizeZ+3);

#declare Axes =
union {
    cylinder { <-.1,2,0>,<sizeX/2-3,2,0>, 0.2
        texture { 
            pigment { color rgb<1,1,1>}
            finish  { phong 0.5 reflection{ 0.00 metallic 0.00} } 
        }
    }
    cone { <sizeX/2-3,2,0>,0.3,<sizeX/2-2,2,0>,0 
        texture { 
            pigment{ color rgb<1,1,1>}
            finish { phong 1 reflection{ 0.00 metallic 0.00} } 
        }
    }
    cylinder { <0,1.9,0>,<0,heightGraph,0>, 0.2
        texture { 
            pigment { color rgb<1,1,1>}
            finish  { phong 0.5 reflection{ 0.00 metallic 0.00} } 
        }
    }
    cone { <0,heightGraph,0>,0.3,<0,heightGraph+1,0>,0 
        texture { 
            pigment{ color rgb<1,1,1>}
            finish { phong 1 reflection{ 0.00 metallic 0.00} } 
        }
    }  
    text { 
        ttf "arial.ttf", 
        "Active cases", 0.02, 0.0 // thickness, offset
        texture{ 
            pigment{ color rgb<1,1,1> } 
            finish { phong 0.1 }
        }
        scale<.8,1,.8>
        translate<.5,heightGraph+.5,-.2>
    }

    no_shadow
    rotate<DegAxes,0,0> 
    translate<0,0,sizeZ+3>         
}


#macro Point(d,p, col1)
cylinder { <d*(sizeX/2-3)/stdLength,p*(heightGraph-2)+2,-.1>,<d*(sizeX/2-3)/stdLength,p*8+2,.1>,0.2 
    texture { 
        pigment { color rgb col1}
        finish  { phong 0.5 reflection{ 0.00 metallic 0.00} } 
    }
    rotate<DegAxes,0,0> 
    translate<0,0,sizeZ+3-.25>
    no_shadow
}

#end

#macro DashBoard(day,active,maxA,l2,l3,l4) 
union {
    box { <sizeX/2, 2, -.1>,<sizeX, heightGraph, .1>   
        texture { 
            pigment{ color rgb<1,1,1>}  
            finish { phong 1 reflection{ 0.00 metallic 0.00} } 
        }
        no_shadow
    }
    box { <sizeX/2-.2, 2, -.2>,<sizeX/2+.2, heightGraph, .1>   
        texture { 
            pigment{ color rgb<.1, .1, .1>}  
            finish { phong 1 reflection{ 0.00 metallic 0.00} } 
        }
        no_shadow
    }
    text { 
        ttf "arial.ttf", 
        concat("Day: ", str(day,2,0),"  Active: ",str(active,3,0),"  maxA: ",str(maxA,3,0)), 0.02, 0.0 // thickness, offset
        texture{ 
            pigment{ color rgb<0,0,0> } 
            finish { phong 0.1 }
        }
        scale<.8,1,.8>
        translate<sizeX/2+1,heightGraph-2,-.2>
        no_shadow
    }
    text { 
        ttf "arial.ttf", 
        l2, 0.02, 0.0 // thickness, offset
        texture{ 
            pigment{ color rgb<0,0,0> } 
            finish { phong 0.1 }
        }
        scale<.8,1,.8>
        translate<sizeX/2+1,heightGraph-3.5,-.2>
        no_shadow
    }
    text { 
        ttf "arial.ttf", 
        l3, 0.02, 0.0 // thickness, offset
        texture{ 
            pigment{ color rgb<0,0,0> } 
            finish { phong 0.1 }
        }
        scale<.8,1,.8>
        translate<sizeX/2+1,heightGraph-5,-.2>
        no_shadow
    }
    text { 
        ttf "arial.ttf", 
        l4, 0.02, 0.0 // thickness, offset
        texture{ 
            pigment{ color rgb<0,0,0> } 
            finish { phong 0.1 }
        }
        scale<.8,1,.8>
        translate<sizeX/2+1,heightGraph-6.5,-.2>
        no_shadow
    }

    rotate<DegAxes,0,0> 
    translate<0,0,sizeZ+3>
}
#end
